/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import com.brennenstuhl.utils.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.BSTitleEditor;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.DefaultPlotEditor;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.layout.LCBLayout;

public class BSChartEditor
extends JPanel
implements ActionListener,
ChartEditor {
    private static final long serialVersionUID = 3899102970382779677L;
    private BSTitleEditor titleEditor;
    private DefaultPlotEditor plotEditor;
    private JCheckBox antialias;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.editor.LocalizationBundle");

    public BSChartEditor(Constants.ChartMode chartMode, JFreeChart chart) {
        this.setLayout(new BorderLayout());
        JPanel other = new JPanel(new BorderLayout());
        other.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel interior = new JPanel((LayoutManager)new LCBLayout(6));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.antialias = new JCheckBox(localizationResources.getString("Draw_anti-aliased"));
        this.antialias.setSelected(chart.getAntiAlias());
        interior.add(this.antialias);
        interior.add(new JLabel(""));
        interior.add(new JLabel(""));
        general.add((Component)interior, "North");
        other.add((Component)general, "North");
        JPanel parts = new JPanel(new BorderLayout());
        TextTitle title = chart.getTitle();
        Plot plot = chart.getPlot();
        JTabbedPane tabs = new JTabbedPane();
        this.titleEditor = new BSTitleEditor(chartMode, (Title)title);
        this.titleEditor.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(localizationResources.getString("Title"), this.titleEditor);
        this.plotEditor = new DefaultPlotEditor(plot);
        this.plotEditor.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(localizationResources.getString("Plot"), (Component)this.plotEditor);
        tabs.add(localizationResources.getString("Other"), other);
        parts.add((Component)tabs, "North");
        this.add(parts);
    }

    public BSTitleEditor getTitleEditor() {
        return this.titleEditor;
    }

    public DefaultPlotEditor getPlotEditor() {
        return this.plotEditor;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public void updateChart(JFreeChart chart) {
        this.titleEditor.setTitleProperties(chart);
        this.plotEditor.updatePlotProperties(chart.getPlot());
        chart.setAntiAlias(this.getAntiAlias());
    }
}

