/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.workers;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.thread.BSLocateTimer;
import com.brennenstuhl.thread.FinderThread;
import com.brennenstuhl.utils.Constants;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.table.DefaultTableModel;

public class BSFinderWorker {
    private static volatile BSFinderWorker singletonInstance = new BSFinderWorker();
    private volatile BSFinder guiObject = null;
    private volatile FinderThread objFinder = null;
    private volatile Timer timer = new Timer();
    private volatile BSLocateTimer timerTask = new BSLocateTimer();
    private volatile int rowLocate = -1;
    private String currentIpAddress = "";

    private BSFinderWorker() {
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, 500L, 500L);
    }

    public static BSFinderWorker getInstance() {
        return singletonInstance;
    }

    public void setGuiObject(BSFinder object) {
        this.guiObject = object;
    }

    public void setFinderObject(FinderThread object) {
        this.objFinder = object;
    }

    public void discoverNetwork() {
        this.guiObject.rescanNetwork();
    }

    public void startLocateTimer(String ipAddress, int row, boolean bChecked) {
        if (bChecked && this.rowLocate >= 0 && row != this.rowLocate || !bChecked) {
            this.timerTask.setInfo(-1);
            if (this.rowLocate != -1) {
                BSFinder.getInstance().setStateLED(this.rowLocate, 0, Constants.StateLED.none);
                this.objFinder.sendLocate(this.rowLocate, this.currentIpAddress, false);
            }
        }
        if (bChecked) {
            this.timerTask.setInfo(row);
            this.rowLocate = row;
            if (row >= 0) {
                this.objFinder.sendLocate(row, ipAddress, true);
            }
        }
        this.currentIpAddress = ipAddress;
    }

    public void clearList() {
        this.startLocateTimer(this.currentIpAddress, this.rowLocate, false);
        this.objFinder.clearBoardList();
    }

    public int getCurrentLocatedDevice() {
        return this.rowLocate;
    }

    public void openBrowser(int row) {
        if (row >= 0) {
            DefaultTableModel model = (DefaultTableModel)this.guiObject.getTable().getModel();
            String ipAddress = (String)model.getValueAt(row, 1);
            BSFinder.log(2, "Open URL " + ipAddress + " in browser");
            try {
                URI uri = new URI("http://" + ipAddress);
                Desktop.getDesktop().browse(uri);
            }
            catch (URISyntaxException e1) {
                BSFinder.log(1, "Open Browser: URI syntax error");
            }
            catch (IOException e1) {
                BSFinder.log(1, "Open Browser: IO Error");
            }
        }
    }
}

