/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.workers;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.unit.Board;
import java.io.BufferedInputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractBsHttpHandler {
    private Board board = null;
    private final String USER_AGENT = "Mozilla/5.0";
    protected String url;
    protected HttpHost httpHost;
    protected HttpClientContext httpContext;
    private CloseableHttpClient httpClient;

    protected AbstractBsHttpHandler(Board board) {
        this.board = board;
    }

    public Board getBoard() {
        return this.board;
    }

    protected ByteBuffer sendHttpGet(int reqType, int parm1, int parm2) {
        ByteBuffer bufferResult = ByteBuffer.allocate(1024);
        byte[] bArray = new byte[2048];
        String specificUrl = "";
        int responseCode = -1;
        Random rn = new Random();
        this.httpClient = HttpClients.createDefault();
        specificUrl = "http://" + this.url;
        switch (reqType) {
            case 300: {
                specificUrl = String.valueOf(specificUrl) + "/rMState?id=" + String.valueOf(rn.nextInt());
                break;
            }
            case 301: {
                specificUrl = String.valueOf(specificUrl) + "/rSState?id=" + String.valueOf(rn.nextInt());
                break;
            }
            case 310: {
                specificUrl = String.valueOf(specificUrl) + "/power?id=" + String.valueOf(rn.nextInt());
                break;
            }
            case 320: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/toggleRelM";
                break;
            }
            case 321: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/toggleRelS";
                break;
            }
            case 400: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/relState.cgi?Rel=0";
                break;
            }
            case 401: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/relState.cgi?Rel=1";
                break;
            }
            case 410: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/power.cgi?Pow=0";
                break;
            }
            case 420: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/toggleRel.cgi?Rel=0";
                break;
            }
            case 421: {
                specificUrl = String.valueOf(specificUrl) + "/cgi-bin/toggleRel.cgi?Rel=1";
                break;
            }
            case 30: {
                specificUrl = String.valueOf(specificUrl) + "/graph?id=" + String.valueOf(parm1) + "&type=" + String.valueOf(parm2);
            }
        }
        HttpGet httpGet = new HttpGet(specificUrl);
        httpGet.addHeader("User-Agent", "Mozilla/5.0");
        int i = 0;
        while (i < 2 && responseCode != 200) {
            CloseableHttpResponse httpResponse;
            try {
                httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpGet, (HttpContext)this.httpContext);
                responseCode = httpResponse.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                BSFinder.log(2, "Connection failed: " + this.board.getIpAddr());
                break;
            }
            switch (responseCode) {
                case 200: {
                    try {
                        int bytesRead;
                        BufferedInputStream input = new BufferedInputStream(httpResponse.getEntity().getContent());
                        while ((bytesRead = input.read(bArray)) > 0) {
                            bufferResult.put(bArray, 0, bytesRead);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 401: {
                    try {
                        Header h = httpResponse.getFirstHeader("WWW-Authenticate");
                        String valueDigest = h.getValue();
                        int index1 = valueDigest.indexOf("nonce=");
                        index1 = valueDigest.indexOf("\"", index1) + 1;
                        int index2 = valueDigest.indexOf(34, index1);
                        String nonce = valueDigest.substring(index1, index2);
                        this.authenticate(nonce, specificUrl);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    responseCode = 200;
                }
            }
            ++i;
        }
        try {
            this.httpClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferResult;
    }

    private void authenticate(String nonce, String url) throws Exception {
        this.httpContext = HttpClientContext.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        String user = this.getBoard().getUsername();
        String pwd = this.getBoard().getPassword();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, pwd));
        try {
            BasicAuthCache authCache = new BasicAuthCache();
            DigestScheme digestAuth = new DigestScheme();
            authCache.put(this.httpHost, (AuthScheme)digestAuth);
            this.httpContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            this.httpContext.setAuthCache((AuthCache)authCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

