/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.unit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LocatorData {
    private byte tag;
    private byte packetLength;
    private byte command;
    private byte boardType;
    private short boardId;
    private short boardFeatures;
    private InetAddress ipAddress;
    private InetAddress ipNetmask;
    private InetAddress ipGateway;
    private short httpPort;
    private byte[] mac = new byte[6];
    private int version;
    private byte[] appTitle = new byte[64];
    private byte checksum;

    public LocatorData(ByteBuffer bb) {
        byte[] b = new byte[4];
        bb.order(ByteOrder.BIG_ENDIAN);
        this.tag = bb.get();
        this.packetLength = bb.get();
        this.command = bb.get();
        this.boardType = bb.get();
        switch (this.packetLength) {
            case 94: {
                this.boardId = bb.get();
                this.boardFeatures = 0;
                break;
            }
            case 97: {
                this.boardId = bb.getShort();
                this.boardId = Short.reverseBytes(this.boardId);
                this.boardFeatures = bb.getShort();
                this.boardFeatures = Short.reverseBytes(this.boardFeatures);
                break;
            }
            default: {
                bb.get();
            }
        }
        bb.get(b);
        try {
            this.ipAddress = InetAddress.getByAddress(b);
        }
        catch (UnknownHostException e) {
            this.ipAddress = null;
        }
        bb.get(b);
        try {
            this.ipNetmask = InetAddress.getByAddress(b);
        }
        catch (UnknownHostException e) {
            this.ipNetmask = null;
        }
        bb.get(b);
        try {
            this.ipGateway = InetAddress.getByAddress(b);
        }
        catch (UnknownHostException e) {
            this.ipGateway = null;
        }
        this.httpPort = bb.getShort();
        this.httpPort = (short)(((this.httpPort & 0xFF) << 8) + (this.httpPort >> 8));
        bb.get(this.mac);
        this.version = bb.getInt();
        int i = 0;
        while (i < 64) {
            this.appTitle[i] = bb.get();
            ++i;
        }
        this.checksum = bb.get();
    }

    static ByteBuffer copyBuffer(byte[] buffer) {
        ByteBuffer bb = ByteBuffer.allocate(buffer.length);
        bb.put(buffer);
        bb.rewind();
        return bb;
    }

    public LocatorData(byte[] buffer) {
        this(LocatorData.copyBuffer(buffer));
    }

    public byte getTag() {
        return this.tag;
    }

    public byte getPacketLength() {
        return this.packetLength;
    }

    public byte getCommand() {
        return this.command;
    }

    public byte getBoardType() {
        return this.boardType;
    }

    public short getBoardId() {
        return this.boardId;
    }

    public short getBoardFeatures() {
        return this.boardFeatures;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public InetAddress getIpNetmask() {
        return this.ipNetmask;
    }

    public InetAddress getIpGateway() {
        return this.ipGateway;
    }

    public short getHttpPort() {
        return this.httpPort;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] getAppTitle() {
        return this.appTitle;
    }

    public byte getChecksum() {
        return this.checksum;
    }
}

