/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.unit;

import com.brennenstuhl.thread.HttpBoardHandler;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.util.Arrays;

public class Board {
    public static final int NUM_ACTIVITYCHECK = 2;
    private byte boardType;
    private short boardId;
    private short boardFeatures;
    private byte[] mac = new byte[6];
    private InetAddress ipAddr;
    private InetAddress ipNetmask;
    private InetAddress ipGateway;
    private long version;
    private short httpPort;
    private byte[] appTitle = new byte[64];
    private HttpBoardHandler httpWorker = null;
    private InterfaceAddress intfLocal = null;
    private int activityCounter = 0;
    private String snmpCommunity = "public";
    private boolean isHistoryActive = false;
    private String username;
    private String password;

    public String asString() {
        return new String(String.valueOf(this.ipAddr.getHostAddress()) + ":" + this.getAppTitleAsString());
    }

    public HttpBoardHandler getHttpWorker() {
        return this.httpWorker;
    }

    public boolean updateBoard(Board board) {
        boolean rc = false;
        if (!this.ipAddr.equals(board.getIpAddr())) {
            this.ipAddr = board.getIpAddr();
            rc = true;
        }
        if (!this.ipNetmask.equals(board.getIpNetmask())) {
            this.ipNetmask = board.getIpNetmask();
            rc = true;
        }
        if (!this.ipGateway.equals(board.getIpGateway())) {
            this.ipGateway = board.getIpGateway();
            rc = true;
        }
        if (this.version != board.getVersion()) {
            this.version = board.getVersion();
            rc = true;
        }
        if (this.httpPort != board.getHttpPort()) {
            this.httpPort = board.getHttpPort();
            rc = true;
        }
        if (!this.getAppTitleAsString().equals(board.getAppTitleAsString())) {
            this.appTitle = board.getAppTitle();
            rc = true;
        }
        if (!(this.intfLocal != null && this.intfLocal.equals(board.getIntfLocal()) || board.getIntfLocal() == null)) {
            this.intfLocal = board.getIntfLocal();
            rc = true;
        }
        if (!this.snmpCommunity.equals(board.getSnmpCommunity())) {
            this.snmpCommunity = board.getSnmpCommunity();
            rc = true;
        }
        if (this.activityCounter != board.activityCounter) {
            this.activityCounter = board.activityCounter;
            rc = true;
        }
        return rc;
    }

    public void snmpExplore() {
        if (this.httpWorker != null) {
            this.httpWorker.stop();
        }
        this.httpWorker = new HttpBoardHandler(this);
        Thread httpThread = new Thread(this.httpWorker);
        httpThread.start();
    }

    public byte getBoardType() {
        return this.boardType;
    }

    public void setBoardType(byte boardType) {
        this.boardType = boardType;
    }

    public short getBoardId() {
        return this.boardId;
    }

    public void setBoardId(short boardId) {
        this.boardId = boardId;
    }

    public short getBoardFeatures() {
        return this.boardFeatures;
    }

    public void setBoardFeatures(short boardFeatures) {
        this.boardFeatures = boardFeatures;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public String getMacAsString() {
        String s = "";
        int i = 0;
        while (i < this.mac.length) {
            s = String.valueOf(s) + String.format("%02x", this.mac[i]);
            if (i < this.mac.length - 1) {
                s = String.valueOf(s) + ":";
            }
            ++i;
        }
        return s;
    }

    public void setMac(byte[] mac) {
        this.mac = mac;
    }

    public InetAddress getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(InetAddress ipAddr) {
        this.ipAddr = ipAddr;
    }

    public InetAddress getIpNetmask() {
        return this.ipNetmask;
    }

    public void setIpNetmask(InetAddress ipNetmask) {
        this.ipNetmask = ipNetmask;
    }

    public InetAddress getIpGateway() {
        return this.ipGateway;
    }

    public void setIpGateway(InetAddress ipGateway) {
        this.ipGateway = ipGateway;
    }

    public long getVersion() {
        return this.version;
    }

    public String getVersionAsString() {
        StringBuffer r = new StringBuffer();
        r.append(Byte.toString((byte)(this.version & 0xFFL)));
        r.append(".");
        r.append(Byte.toString((byte)((this.version & 0xFF00L) >> 8)));
        r.append(".");
        r.append(Short.toString((short)((this.version >> 24) + (this.version >> 16 & 0xFFL))));
        return r.toString();
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public short getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(short httpPort) {
        this.httpPort = httpPort;
    }

    public byte[] getAppTitle() {
        return this.appTitle;
    }

    public String getAppTitleAsString() {
        return new String(this.appTitle).trim();
    }

    public void setAppTitle(byte[] appTitle) {
        this.appTitle = appTitle;
    }

    public void setAppTitleAsString(String s) {
        Arrays.fill(this.appTitle, (byte)0);
        this.appTitle = s.getBytes();
    }

    public boolean isActive() {
        return this.activityCounter > 0;
    }

    public void setActive() {
        this.activityCounter = 2;
    }

    public void setInactive() {
        if (this.activityCounter > 0) {
            --this.activityCounter;
        }
    }

    public InterfaceAddress getIntfLocal() {
        return this.intfLocal;
    }

    public void setIntfLocal(InterfaceAddress intfLocal) {
        this.intfLocal = intfLocal;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.httpWorker != null) {
            this.httpWorker.clearHttpContext();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        if (this.httpWorker != null) {
            this.httpWorker.clearHttpContext();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mac);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Board other = (Board)obj;
        return Arrays.equals(this.mac, other.mac);
    }

    public String toString() {
        return String.valueOf(this.ipAddr.getHostAddress()) + " - " + this.getMacAsString() + " (" + this.getAppTitleAsString() + ")";
    }

    public boolean isHistoryActive() {
        return this.isHistoryActive;
    }

    public void setHistoryActive(boolean isHistoryActive) {
        this.isHistoryActive = isHistoryActive;
    }
}

