/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.thread;

import com.brennenstuhl.gui.BSChartPanel;
import com.brennenstuhl.gui.ChartWindow;
import com.brennenstuhl.gui.renderer.AbstractHistoryRenderer;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.workers.HistoryHandler;
import java.awt.Component;
import java.io.IOException;
import java.util.prefs.BackingStoreException;

public class HistoryRendererThread
extends AbstractHistoryRenderer
implements Runnable {
    private volatile boolean bStopThread = false;
    private volatile boolean isReady = false;

    public synchronized void stop() {
        this.bStopThread = true;
        this.getHistoryHandler().stop(true);
    }

    public boolean isStopped() {
        return this.bStopThread;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public HistoryRendererThread(Constants.ChartMode chartMode, ChartWindow historyWindow) {
        super(historyWindow);
        this.setHistoryHandler(new HistoryHandler(chartMode, this.getHistoryWindow().getBoard()));
        this.setChartPanel(new BSChartPanel(chartMode, this.createChart(chartMode)));
    }

    @Override
    public void run() {
        BSChartPanel chart = this.getChartPanel();
        try {
            HistoryRendererThread.restoreChart(chart);
        }
        catch (IOException | ClassNotFoundException | BackingStoreException e1) {
            e1.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.getHistoryWindow().getChartPanel(chart.is24h()).add((Component)((Object)chart));
        chart.setVisible(false);
        while (!this.isStopped()) {
            this.getHistoryWindow().showLoader(chart.is24h());
            this.setReady(false);
            try {
                this.updateChart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getHistoryWindow().hideLabel(chart.is24h());
            this.setReady(true);
            if (!chart.isEmpty()) {
                chart.setVisible(true);
            } else {
                chart.setVisible(false);
                this.getHistoryWindow().showNoData(chart.is24h());
            }
            try {
                if (chart.is24h()) {
                    Thread.sleep(3600000L);
                    continue;
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            HistoryRendererThread.persistChart(chart);
        }
        catch (IOException | ClassNotFoundException | BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

