/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.thread;

import com.brennenstuhl.exception.WrongBinaryException;
import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.DownloadMultiple;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.workers.MBootServer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;

public class Bootp
implements Runnable {
    private MBootServer mBootServer = null;
    private byte[] targetImage = null;
    private List<Board> boardList = null;
    private DownloadMultiple dlgDownload = null;
    private boolean bAbortBOOTP = false;

    public Bootp(DownloadMultiple dialog, List<Board> boardList, File file) throws IOException {
        dialog.setProgrammingActive(true);
        this.dlgDownload = dialog;
        this.boardList = boardList;
        BSFinder.log(2, "Load target file \"" + file.getName() + "\"; length = " + file.length() + " Bytes.");
        this.targetImage = new byte[(int)file.length()];
        BufferedInputStream input = null;
        int totalBytesRead = 0;
        input = new BufferedInputStream(new FileInputStream(file));
        while (totalBytesRead < this.targetImage.length) {
            int bytesRemaining = this.targetImage.length - totalBytesRead;
            int bytesRead = ((InputStream)input).read(this.targetImage, totalBytesRead, bytesRemaining);
            if (bytesRead <= 0) continue;
            totalBytesRead += bytesRead;
        }
        ((InputStream)input).close();
    }

    public void abortBootPUpdate() {
        this.bAbortBOOTP = true;
        if (this.mBootServer != null) {
            this.mBootServer.abortBootPUpdate();
        }
    }

    @Override
    public void run() {
        BSFinder.log(1, "Bootp RUN");
        try {
            this.mBootServer = new MBootServer();
        }
        catch (IOException e) {
            BSFinder.log(2, "Could not create UDP channel for BOOTP/TFTP");
            return;
        }
        ListIterator<Board> itBoard = this.boardList.listIterator();
        int tableIndex = 0;
        while (!this.bAbortBOOTP && itBoard.hasNext()) {
            Board board = itBoard.next();
            try {
                this.mBootServer.startDownload(this.dlgDownload, tableIndex, this.targetImage, board);
            }
            catch (Exception e) {
                if (e instanceof WrongBinaryException) {
                    BSFinder.log(2, "Binary file not compatible with hardware");
                    this.dlgDownload.setMessage("MBootServer.message.wrongImage");
                } else if (e instanceof IOException) {
                    BSFinder.log(2, "BOOTP abort");
                    this.dlgDownload.setMessage("MBootServer.message.socketErr");
                }
                this.dlgDownload.setProgress(tableIndex, -4);
            }
            this.dlgDownload.setState("");
            this.dlgDownload.setProgrammingActive(false);
            ++tableIndex;
        }
        this.mBootServer.closeChannels();
        BSFinder.log(1, "Bootp: EXIT");
    }
}

